import ui
import app
import net
import chat
import localeInfo
import player
import uiCommon
import uiScriptLocale

class AlignmentWindow(ui.ScriptWindow):
	ALIGNMENT_LIST = (
			("|cFF00CCFF Cavaleresc|r", 20000),
			("|cFF0090FF Nobil|r", 8000),
			("|cFF5C6EFF Bun|r", 4000),
			("|cFF9B9BFF Prietenos|r", 1000),
			("|cFFFFFFFF Neutru|r", 0),
			("|cFFCF7500 Agresiv|r", -1000),
			("|cFFEB5300 Dezonorat|r", -4000),
			("|cFFE30000 Rutcios|r", -8000),
			("|cFFFF0000 Crud|r", -20000),
		)

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.isLoaded = 0
		self.price = 0
		self.alertDialog = None
		self.__LoadWindow()

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		
	def Show(self):
		self.__LoadWindow()
		ui.ScriptWindow.Show(self)
		
	def __LoadWindow(self):
		if self.isLoaded == 1:
			return
			
		self.isLoaded = 1
		try:
			pyScrLoader = ui.PythonScriptLoader()			
			pyScrLoader.LoadScriptFile(self, "UIScript/AlignmentWindow.py")
		
		except:
			import exception
			exception.Abort("AlignmentWindow.LoadWindow.LoadObject")
			
		try:
			getObject = self.GetChild
			
			self.titleBar = getObject("TitleBar")
			self.alignmentsList = getObject("AlignmentsListBox")
			self.buyButton = getObject("ChangeButton")
			
		except:
			import exception
			exception.Abort("AlignmentWindow.LoadWindow.BindObject")
			
		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))
		self.buyButton.SetEvent(ui.__mem_func__(self.OnPressBuyButton))
		
		for alignment in self.ALIGNMENT_LIST:
			self.alignmentsList.AppendItem(Item(alignment[0]))
			
		self.alignmentsList.SelectIndex(0)
		
	def OnPressBuyButton(self):
		alignmentIndex = self.alignmentsList.GetSelectedItem().GetText()
		
		alertDialog = uiCommon.QuestionDialog()
		alertDialog.SetWidth(285)
		alertDialog.SetText(uiScriptLocale.ALIGNMENT_SELECT % (str(alignmentIndex)))

		alertDialog.SetAcceptEvent(lambda arg1=str(alignmentIndex): self.OnBuyMarble(arg1))
		alertDialog.SetCancelEvent(ui.__mem_func__(self.OnCloseAlertDialog))
		alertDialog.Open()
		self.alertDialog = alertDialog
		
	def OnCloseAlertDialog(self):
		if not self.alertDialog:
			return
		self.alertDialog.Close()
		self.alertDialog = None
	
	def OnBuyMarble(self, alignmentIndex):
		self.OnCloseAlertDialog()
		if alignmentIndex == "":
			return
			
		for alignment in xrange(len(self.ALIGNMENT_LIST)):
			if alignmentIndex == self.ALIGNMENT_LIST[alignment][0]:
				itemVnum = self.ALIGNMENT_LIST[alignment][1]
				net.SendChatPacket("/alignment %d" % (int(itemVnum)))
				chat.AppendChat(chat.CHAT_TYPE_INFO, uiScriptLocale.ALIGNMENT_CHANGE_TEXT % (str(alignmentIndex)))
				break

	def Destroy(self):
		self.alertDialog = None
		self.ClearDictionary()
		
	def Close(self):
		if self.alertDialog:
			self.OnCloseAlertDialog()
 		self.Hide()
 	
	def OnPressEscapeKey(self):
		self.Close()
		return TRUE
		
class Item(ui.ListBoxEx.Item):

	def __init__(self, text):
		ui.ListBoxEx.Item.__init__(self)
		self.canLoad=0
		self.text=text
		self.textLine=self.__CreateTextLine(text[:50])

	def __del__(self):
		ui.ListBoxEx.Item.__del__(self)

	def GetText(self):
		return self.text

	def SetSize(self, width, height):
		ui.ListBoxEx.Item.SetSize(self, 113, height)

	def __CreateTextLine(self, text):
		textLine=ui.TextLine()
		textLine.SetParent(self)
		textLine.SetPosition(0, 0)
		textLine.SetText(text)
		textLine.Show()
		return textLine
