import chat
import net
import player
import ui
import exception
import wndMgr
import uiToolTip
import localeInfo

class DamageTopWindow(ui.ScriptWindow):
	RANKING_ROW_NUMBER = 10
	
	M2EMPIREICON = {
		0: 'd:/ymir work/ui/public/battle/empire_empty.sub', 
		1: 'd:/ymir work/ui/public/battle/empire_shinsu.sub', 
		2: 'd:/ymir work/ui/public/battle/empire_chunjo.sub', 
		3: 'd:/ymir work/ui/public/battle/empire_jinno.sub'
	}
	
	CATEGORY_PVP_HIT = 0
	CATEGORY_PVP_SKILL = 1
	CATEGORY_PVM_HIT = 2
	CATEGORY_PVM_SKILL = 3

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		
		self.titleBar = None
		self.listBackground = None
		
		self.buttontooltip = None
		self.ShowButtonToolTip = False
		
		self.selectTypeFirst = None
		self.selectTypeSecond = None
		
		self.xStart = 0
		self.yStart = 0
		
		self.rankingDict = { }
		self.rankingInfo = { self.CATEGORY_PVP_HIT : { }, self.CATEGORY_PVP_SKILL : { }, self.CATEGORY_PVM_HIT : { }, self.CATEGORY_PVM_SKILL : { }, }
		self.currentPage = self.CATEGORY_PVP_HIT
		self.buttonList = []
		
		self.__LoadWindow()

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __LoadWindow(self):
		try:
			PythonScriptLoader = ui.PythonScriptLoader()
			PythonScriptLoader.LoadScriptFile(self, "UIScript/damagetopwindow.py")
		except:
			exception.Abort("DamageTopWindow.__LoadWindow.LoadObject")

		try:
			self.titleBar = self.GetChild("TitleBar")
			self.listBackground = self.GetChild("list_background")
			
			self.buttonList.append(self.GetChild("PvPButton"))
			self.buttonList.append(self.GetChild("PvMButton"))
			self.buttonList.append(self.GetChild("HitButton"))
			self.buttonList.append(self.GetChild("SkillButton"))
		except:
			exception.Abort("DamageTopWindow.__LoadWindow.BindObject")
			
		try:
			self.CreateRanking()
		except:
			exception.Abort("DamageTopWindow.__LoadWindow.CreateRanking")
			
		try:
			self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))
			
			self.selectTypeFirst = ui.RadioButtonGroup.Create([[self.buttonList[0], lambda : self.SelectButton(0), None], [self.buttonList[1], lambda : self.SelectButton(1), None]])
			self.selectTypeSecond = ui.RadioButtonGroup.Create([[self.buttonList[2], lambda : self.SelectButton(2), None], [self.buttonList[3], lambda : self.SelectButton(3), None]])

			self.buttontooltip = uiToolTip.ToolTip()
			self.buttontooltip.ClearToolTip()
			
			self.GetChild("Position").OnMouseOverIn = lambda arg = localeInfo.DAMAGE_TOP_POSITION : self.OverInToolTipButton(arg)
			self.GetChild("Position").OnMouseOverOut = lambda : self.OverOutToolTipButton()
			self.GetChild("AttackerName").OnMouseOverIn = lambda arg = localeInfo.DAMAGE_TOP_NAME : self.OverInToolTipButton(arg)
			self.GetChild("AttackerName").OnMouseOverOut = lambda : self.OverOutToolTipButton()
			self.GetChild("AttackerLvl").OnMouseOverIn = lambda arg = localeInfo.DAMAGE_TOP_LEVEL : self.OverInToolTipButton(arg)
			self.GetChild("AttackerLvl").OnMouseOverOut = lambda : self.OverOutToolTipButton()
			self.GetChild("AttackerEmpire").OnMouseOverIn = lambda arg = localeInfo.DAMAGE_TOP_KINGDOM : self.OverInToolTipButton(arg)
			self.GetChild("AttackerEmpire").OnMouseOverOut = lambda : self.OverOutToolTipButton()
			self.GetChild("VictimName").OnMouseOverIn = lambda arg = localeInfo.DAMAGE_TOP_VICTIM_NAME : self.OverInToolTipButton(arg)
			self.GetChild("VictimName").OnMouseOverOut = lambda : self.OverOutToolTipButton()
			self.GetChild("Damage").OnMouseOverIn = lambda arg = localeInfo.DAMAGE_TOP_DMG : self.OverInToolTipButton(arg)
			self.GetChild("Damage").OnMouseOverOut = lambda : self.OverOutToolTipButton()
		except:
			exception.Abort("DamageTopWindow.__LoadWindow.BindEvent")
			
	def SelectButton(self, index):
		toSelectPage = 0
		if self.selectTypeFirst and self.selectTypeSecond:
			selectedFirst = self.selectTypeFirst.selectedBtnIdx
			selectedSecond = self.selectTypeSecond.selectedBtnIdx
			
			if index == self.CATEGORY_PVP_HIT or index == self.CATEGORY_PVP_SKILL:
				if selectedSecond == 0:
					toSelectPage = 0 + (2*index)
				elif selectedSecond == 1:
					toSelectPage = 1 + (2*index)
			elif index == self.CATEGORY_PVM_HIT or index == self.CATEGORY_PVM_SKILL:
				if selectedFirst == 0:
					toSelectPage = 0 + (1*(index-2))
				elif selectedFirst == 1:
					toSelectPage = 2 + (1*(index-2))
					
		self.currentPage = toSelectPage
		self.RefreshRanking()

	def CreateRanking(self):
		for i in xrange(self.RANKING_ROW_NUMBER):
			self.rankingDict[i] = {}
			
			Y_GAP = 0
			if i == 0:
				self.rankingDict[i]["background"] = ui.MakeImageBox(self.listBackground, "d:/ymir work/ui/game/damage_top/first_place.sub", 3, 26 + i*25)
			elif i == 1:
				self.rankingDict[i]["background"] = ui.MakeImageBox(self.listBackground, "d:/ymir work/ui/game/damage_top/second_place.sub", 3, 26 + i*25)
			elif i == 2:
				self.rankingDict[i]["background"] = ui.MakeImageBox(self.listBackground, "d:/ymir work/ui/game/damage_top/third_place.sub", 3, 26 + i*25)
			else:
				self.rankingDict[i]["background"] = ui.MakeImageBox(self.listBackground, "d:/ymir work/ui/game/damage_top/normal.sub", 3, 33 + i*23)
				
			if i >= 0 and i < 3:
				Y_GAP = 2
				
			self.rankingDict[i]["position"] = ui.MakeTextLine(self.rankingDict[i]["background"], False, False, 23, 9 + Y_GAP)
			self.rankingDict[i]["name"] = ui.MakeTextLine(self.rankingDict[i]["background"], False, False, 107, 9 + Y_GAP)
			self.rankingDict[i]["level"] = ui.MakeTextLine(self.rankingDict[i]["background"], False, False, 196, 9 + Y_GAP)
			self.rankingDict[i]["empire"] = ui.MakeImageBox(self.rankingDict[i]["background"], self.M2EMPIREICON[0], 226, 3 + Y_GAP)
			self.rankingDict[i]["victim"] = ui.MakeTextLine(self.rankingDict[i]["background"], False, False, 320, 9 + Y_GAP)
			self.rankingDict[i]["damage"] = ui.MakeTextLine(self.rankingDict[i]["background"], False, False, 420, 9 + Y_GAP)
			
	def RefreshRanking(self):
		for i in xrange(10):
			if self.rankingInfo[self.currentPage].has_key(i):
				self.rankingDict[i]["position"].SetText(str(self.rankingInfo[self.currentPage][i]["position"]))
				self.rankingDict[i]["name"].SetText(str(self.rankingInfo[self.currentPage][i]["name"]))
				self.rankingDict[i]["level"].SetText(str(self.rankingInfo[self.currentPage][i]["level"]))
				self.rankingDict[i]["empire"].LoadImage(self.M2EMPIREICON[self.rankingInfo[self.currentPage][i]["empire"]])
				self.rankingDict[i]["victim"].SetText(str(self.rankingInfo[self.currentPage][i]["victim"]))
				self.rankingDict[i]["damage"].SetText(localeInfo.AddPointToNumberString(self.rankingInfo[self.currentPage][i]["damage"]))
			else:
				self.rankingDict[i]["position"].SetText("")
				self.rankingDict[i]["name"].SetText("")
				self.rankingDict[i]["level"].SetText("")
				self.rankingDict[i]["empire"].LoadImage(self.M2EMPIREICON[0])
				self.rankingDict[i]["victim"].SetText("")
				self.rankingDict[i]["damage"].SetText("")
		
	def AddRankingMember(self, type, position, name, level, empire, victim, damage):
		realType = type - 1
		realPos = position - 1
		
		if not self.rankingInfo.has_key(realType):
			return
			
		if not self.rankingInfo[realType].has_key(realPos):
			self.rankingInfo[realType][realPos] = { }

		self.rankingInfo[realType][realPos]["position"] = position
		self.rankingInfo[realType][realPos]["name"] = name
		self.rankingInfo[realType][realPos]["level"] = level
		self.rankingInfo[realType][realPos]["empire"] = empire
		self.rankingInfo[realType][realPos]["victim"] = victim
		self.rankingInfo[realType][realPos]["damage"] = damage
			
	def OverInToolTipButton(self, arg):
		arglen = len(str(arg))
		pos_x, pos_y = wndMgr.GetMousePosition()
	
		self.buttontooltip.ClearToolTip()
		self.buttontooltip.SetThinBoardSize(10 * arglen)
		self.buttontooltip.SetToolTipPosition(pos_x + 50, pos_y + 50)
		self.buttontooltip.AppendTextLine(arg, 0xffffffff)
		self.buttontooltip.Show()
		self.ShowButtonToolTip = True
	
	def OverOutToolTipButton(self):
		self.buttontooltip.Hide()
		self.ShowButtonToolTip = False

	def ButtonToolTipProgress(self) :
		if self.ShowButtonToolTip :
			pos_x, pos_y = wndMgr.GetMousePosition()
			self.buttontooltip.SetToolTipPosition(pos_x + 50, pos_y + 50)

	def Close(self):		
		self.Hide()
		
		if self.buttontooltip:
			self.buttontooltip.Hide()
			self.ShowButtonToolTip = False
		
	def Destroy(self):
		self.ClearDictionary()
		
		self.titleBar = None
		self.listBackground = None
		self.rankingDict = { }
		
		self.selectTypeFirst = None
		self.selectTypeSecond = None
		
		self.rankingInfo = { self.CATEGORY_PVP_HIT : { }, self.CATEGORY_PVP_SKILL : { }, self.CATEGORY_PVM_HIT : { }, self.CATEGORY_PVM_SKILL : { }, }
		self.currentPage = self.CATEGORY_PVP_HIT
		self.buttonList = []
		
		self.buttontooltip = None
		self.ShowButtonToolTip = False
		
	def Open(self):
		if self.IsShow():
			return
						
		self.SetCenterPosition()
		self.Show()
		
		(self.xStart, self.yStart, z) = player.GetMainCharacterPosition()

	def OnPressEscapeKey(self):
		self.Close()
		return True
		
	def OnUpdate(self):
		self.ButtonToolTipProgress()
		
		USE_SHOP_LIMIT_RANGE = 1000

		(x, y, z) = player.GetMainCharacterPosition()
		if abs(x - self.xStart) > USE_SHOP_LIMIT_RANGE or abs(y - self.yStart) > USE_SHOP_LIMIT_RANGE:
			self.Close()
		
		