import ui
import snd
import net
import chat
import app
import localeInfo
import constInfo
import chrmgr
import player
import background
import event
import translate
import uiToolTip

class DuelWindowDialog(ui.ScriptWindow):
	
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.toolTip = None
		self.toolTip = uiToolTip.ToolTip()
		self.__Initialize()
		self.__Load()

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		
	def __Initialize(self):
		self.titleBar = 0
		self.DuelNormalButton = 0
		self.DuelTacticButton = 0

	def __Load_LoadScript(self, fileName):
		try:
			pyScriptLoader = ui.PythonScriptLoader()
			pyScriptLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("DuelWindowDialog.__Load_LoadScript")
			
	def __Load_BindObject(self):
		try:
			GetObject = self.GetChild
			self.titleBar = GetObject("titlebar")
			self.DuelNormalButton = self.GetChild2("DuelNormalButton")
			self.DuelTacticButton = self.GetChild2("DuelTacticButton")
		except:
			import exception
			exception.Abort("DuelWindowDialog.__Load_BindObject")
		
		if self.DuelNormalButton:
			self.DuelNormalButton.SetEvent(ui.__mem_func__(self.ClickDuelNormalButton))

		if self.DuelTacticButton:
			self.DuelTacticButton.SetEvent(ui.__mem_func__(self.ClickDuelTacticButton))
	
	def __Load(self):
		self.__Load_LoadScript("uiscript/duelwindowdialog.py")
		
		self.__Load_BindObject()
		self.SetCenterPosition()

		g=1
		self.DuelNormalButton.ShowToolTip = lambda arg=g: self.__OverDuelNormalIn()
		self.DuelNormalButton.HideToolTip = lambda arg=g: self.__OverDuelNormalOut()
		self.DuelTacticButton.ShowToolTip = lambda arg=g: self.__OverDuelTacticIn()
		self.DuelTacticButton.HideToolTip = lambda arg=g: self.__OverDuelTacticOut()

		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))
			
	def ClickDuelNormalButton(self):
		vid = player.GetTargetVID()
		net.SendChatPacket("/pvp %d 0" % (vid))
		self.Hide()

	def ClickDuelTacticButton(self):
		vid = player.GetTargetVID()
		net.SendChatPacket("/pvp %d 1" % (vid))
		self.Hide()

	def __OverDuelNormalIn(self):
		a=0
		self.__ShowStatToolTip(translate.DUELWINDOW_NORMALDUEL)

	def __OverDuelNormalOut(self):
		a=0
		self.__HideStatToolTip()

	def __OverDuelTacticIn(self):
		a=0
		self.__ShowStatToolTip(translate.DUELWINDOW_TACTICDUEL)

	def __OverDuelTacticOut(self):
		a=0
		self.__HideStatToolTip()

	def __ShowStatToolTip(self, xkozed1, xkozed2=""):
		self.toolTip.ClearToolTip()
		self.toolTip.AppendTextLine(xkozed1)
		if (xkozed2 != ""):
			self.toolTip.AppendTextLine(xkozed2)
		self.toolTip.Show()

	def __HideStatToolTip(self):
		self.toolTip.Hide()

	def Close(self):
		self.Hide()

	def OnPressEscapeKey(self):
		self.Close()
		return True	
